//*********************************************************************
// [COMIDAS sample program by COMIZOA Inc., Ltd]
//
// Subject : 
//   Motion Control, List Motion
// Contents: 
//   -.   Ʈ   뿹 ̱  Դϴ. 
//	 -.   Ʈ ޴ 311 "[׸ 3-21] 3ȸ Coordinated 
//	    Motion ̷ ۾ "  ׸  ۾  
//	    ׷Դϴ. 
//	 -.   带 Ͽ X & Y  ǥ Ͽ ȭ
//		 ǥϰ,  C:\motion.txt Ͽ մϴ. ڴ  
//	    ͸ Ȯϸ  θ Ȯ  ֽϴ.
// Remarks:
//   -.  α׷ COMI-LX501  Դϴ. 
//*********************************************************************

#include <windows.h>
#include <stdio.h>
#include <conio.h>
#include "comidaslx.h"

// (ä) ȣ //
#define X_AXIS	0
#define Y_AXIS	1
// Axis Map    Mask //
#define X_MASK	1
#define Y_MASK	2
#define Z_MASK	4
#define U_MASK	8

#define MAP0	0

BOOL bAbortThread;

//*********************************************************************
// Monitor_Log_Thread() : X & Y  ġ  Ͽ ȭ α
//	Ͽ ǥϱ   Լ
//*********************************************************************
DWORD WINAPI Monitor_Log_Thread(LPVOID lpParameter)
{
	HANDLE hDevice = (HANDLE)lpParameter;
	double fXPos, fYPos;
	FILE *fp;
	if((fp = fopen("c:\\motion.txt", "w")) == NULL){
		printf("c:\\motion.txt    Ƿ ġ α ͸   ϴ.\n");
		printf("ƹŰ   ۾  ˴ϴ.\n");
		getch();
	}
	bAbortThread = FALSE;
	while(!bAbortThread)
	{
		fXPos = COMILX_MC_GetPosition_C(hDevice, X_AXIS);
		fYPos = COMILX_MC_GetPosition_C(hDevice, Y_AXIS);
		printf("Position (X, Y) = (%.0f, %.0f)\n", fXPos, fYPos);
		if(fp) fprintf(fp, "%.0f	%.0f\n", fXPos, fYPos);
	}
	if(fp) fclose(fp);
	bAbortThread=FALSE;
	return 0;
}

void main()
{
	double fDistList[2];

	if(!COMILX_LoadDll())
		exit(-1); // Load Dll Failure
	
	HANDLE hDevice = COMILX_LoadDevice(COMI_LX501, 0);
	if(hDevice == INVALID_HANDLE_VALUE)
		exit(-1); // Load Device Failure
	
	COMILX_MC_Reset(hDevice);

	COMILX_MC_BeginList(hDevice); //  Ʈ   //
	  COMILX_MC_MapAxes(hDevice, MAP0, X_MASK|Y_MASK); // Map X & Y axis //
	  // Set Trapezoidal Speed Mode //
	  COMILX_MC_SetSpeedModeMx(hDevice, MAP0, 1); 
	  // Set work speed=500, Acceleration=1000 //
	  COMILX_MC_SetSpeedMx(hDevice, MAP0, 500, 1000);
	  // (1000,0)ŭ   ̵ //
	  fDistList[0]=1000;	fDistList[1]=0;
	  COMILX_MC_Line(hDevice, MAP0, fDistList);
	  // ߽ Offset = (0, 500), End Angle = 90 DEG  //
	  //   ȣ ̵							//
	  COMILX_MC_Arc_a(hDevice, MAP0, 0, 500, 90);
	  // (0,1000)ŭ   ̵ //
	  fDistList[0]=0;	fDistList[1]=1000;
	  COMILX_MC_Line(hDevice, MAP0, fDistList);
	COMILX_MC_EndList(hDevice); //  Ʈ  ħ //

	// X&Y  ġ  ȭ α Ͽ ǥϱ 	//
	// Monitor_Log_Thread 带 Ѵ.					//
	CreateThread(NULL, 0, Monitor_Log_Thread, hDevice, 0, NULL);

	COMILX_MC_StartListMotion(hDevice); // Ʈ   //
	// Ʈ   Ϸ  ٸ //
	while(!COMILX_MC_CheckListMotionDone(hDevice))
		;
	
	bAbortThread=TRUE; // Monitor_Log_Thread  Ų.
	while(bAbortThread) // Monitor_Log_Thread 尡   ٸ.
		;
	COMILX_UnloadDevice(hDevice);
	COMILX_UnloadDll();
}


